*! version 5.0
* 13 August 2018
* NIDS
* Coding employment status

*====================================================================================================================================

* NOTE		

/*

The following variables were used in the original do-file, they are listed with their variable name which is consistent across waves
as well as the corresponding question number in each wave. 

variable name		w1				w2             w3				w4				w5
em1 			->	e1			->	e2         ->  e2			->	eb1			->	eb1
em2				->	e18			->	e23        ->  e23			->	eb16		->	eb16
ems				->	e28			->	e33        ->  e33			->	ec1			->	ec1
emc				->	e40			->	e48        ->  e48			->	ed1			->	ed1
emp				->	e45			->	e53        ->  e53			->	ee1			->	ee1
emh				->	e52			->	e61        ->  e61			->	ef1			->	ef1
unemwnt			->	e66			->	e74        ->  e74			->	eg6			->	eg6
unems*			->	e71_1a 		->	e79*       ->  e79*			->	eg11*		->	eg11*

*/

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

global DataIN "C:\Users\Admin\Desktop\W2"    			//File path to where data is located. Change this path according to where your data folder in located on your computer.
global DataOUT "C:\Users\Admin\Desktop\W2"

global temp "C:\Users\Admin\Desktop\W2"					// tempfile to hold all the working datasets, all working datasets will
														// be deleted from this folder at the completion of the do file execution.
global VersionIN "W2_Anon_V4.0.0"
global VersionOUT "Derived"

version 12.0											// version of Stata being used, this is needed for the rename command.

set more off
*=====================================================================================================================================

* ADULT

use "$DataIN\Adult_$VersionIN.dta", clear

cap renpfix "w2_a_" ""

gen done_nothing = 0
replace done_nothing = 1 if unems1 == 11

gen done_something = 0
forvalues x = 1/10 {
	forvalues t= 1/10 {
	replace done_something = 1 if unems`x' == `t'
	}
}

gen Employed= (em1==1|em2==1|ems==1|emc==1|emp==1|emh==1)
gen Not_economically_active= (Employed==0 & unemwnt==2)
gen Unemployed_discouraged= (Employed==0 & unemwnt==1 & done_nothing == 1)
gen Unemployed_strict= (Employed==0 & unemwnt==1 & done_something == 1)

gen state=.
replace state=0 if Not_economically_active==1
replace state=1 if Unemployed_discouraged==1
replace state=2 if Unemployed_strict==1
replace state=3 if Employed==1
replace state=-8 if state == . & outcome == 1

replace state=. if outcome != 1

cap la def state 0"Not Economically Active" 1"Unemployed_Discouraged" 2"Unemployed_Strict" 3"Employed" -8"Refused"
cap la val state state

cap ren state state_fine_a

gen state2=0 if state_fine_a == 0
replace state2=1 if state_fine_a >=1 & state_fine_a <=2
replace state2=2 if state_fine_a ==3
replace state2=-8 if state_fine_a == 4

cap la def state2 0"Not Economically Active" 1"Unemployed" 2"Employed" -8"Refused"
cap la val state2 state2
cap ren state2 state_coarse_a

keep pid w2_hhid state_fine_a  state_coarse_a outcome em1 em2 ems emc emh unemwnt unemmn done_nothing done_something unems* Employed Not_economically_active Unemployed_discouraged Unemployed_strict

sort  pid

save "$temp\1_labour.dta", replace

*-------------------------------------------------------------------------------------------------------------------------------------

* PROXY

use "$DataIN\Proxy_$VersionIN.dta", clear

cap renpfix "w2_p_" ""

gen state2=.
 replace state2=0 if emactcur_u>=5 & emactcur_u<=8
 replace state2=2 if emactcur_u>=1 & emactcur_u<=4
 replace state2=1 if emactcur_u==9
 replace state2=-8 if outcome == 1 & state2 == .

cap la def state2 0"Not Economically Active" 1"Unemployed" 2"Employed" -8"Refused"
cap la val state2 state2
cap ren state2 state_coarse_p


keep pid w2_hhid state_coarse_p
sort pid

save "$temp\2_labour.dta", replace

*-------------------------------------------------------------------------------------------------------------------------------------

* MERGING THE ABOVE INTO THE INDIVIDUAL DERIVED DATASET FOR RELEASE

use "$DataIN\indderived_$VersionIN.dta", clear

sort pid
merge 1:1 pid w2_hhid using "$temp\1_labour.dta"
drop if _m == 2
drop _merge

sort pid
merge 1:1 pid w2_hhid using "$temp\2_labour.dta"
drop if _m == 2
drop _merge


gen state_coarse_ap = .
replace state_coarse_ap = state_coarse_a if state_coarse_a !=.
replace state_coarse_ap = state_coarse_p if state_coarse_p !=.

cap la def state_coarse_ap 0"Not Economically Active" 1"Unemployed" 2"Employed" -8"Refused"
cap la val state_coarse_ap state_coarse_ap

cap ren state_coarse_ap w2_empl_stat_inclprox
cap ren state_fine_a w2_empl_stat

lab var w2_empl_stat_inclprox "Employment status - including Proxy"
lab var  w2_empl_stat "Employment status - Adult only"

cap drop outcome em1 ems em2 emc emh unemwnt unemmn unems1 unems2 unems3 unems4 unems5 unems6 unems7 unems8 unems9 unems10 unemsrcst unemsrsrc unemsrsrc_o
cap drop   Unemployed_strict Unemployed_discouraged Not_economically_active Employed done_something done_nothing
drop state_coarse_a state_coarse_p state_fine_a state_coarse_ap

save "$DataOUT\indderived_$VersionOUT.dta", replace

* end of do file
*=====================================================================================================================================
